/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskRootNode;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWTaskRootPropertyPanel
extends VWTaskPropertyPanel {
    VWTaskNumericProperty m_registryPort = null;
    JTextField m_localHost = null;
    VWTaskRootNode m_node = null;
    VWTaskTabPanel m_generalPanel = null;

    public VWTaskRootPropertyPanel(VWTaskRootNode node) throws Exception {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = node;
        this.initLayout();
        this.resetProperties();
        this.refresh();
    }

    public void refresh() {
    }

    private void initLayout() {
        this.m_generalPanel = this.getGeneralPanel();
        this.m_generalPanel.addVWTaskPropertyChangedListener(this);
        this.add((Component)this.m_generalPanel, "Center");
    }

    private VWTaskTabPanel getGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)this.getApplicationSettingsPanel(), c);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWToolbarBorder getApplicationSettingsPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ApplicationSettings, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_registryPort = new VWTaskNumericProperty("");
        this.m_registryPort.setName(VWResource.RegistryPort);
        panel.add((Component)new JLabel(this.m_registryPort.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_registryPort, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_localHost = new JTextField();
        this.m_localHost.setName(VWResource.LocalHost);
        panel.add((Component)new JLabel(this.m_localHost.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_localHost, (Object)c, false);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        return borderPanel;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_node.displayHelp();
            }
        }
        catch (Exception ex) {
            VWTaskCore.getInstance().displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        this.m_node.setRegistryPort(Integer.parseInt(this.m_registryPort.getText()));
        this.m_node.setLocalHost(this.m_localHost.getText().trim());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() throws Exception {
        this.m_registryPort.setText("" + this.m_node.getRegistryPort());
        this.m_localHost.setText(this.m_node.getLocalHost());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            this.m_generalPanel.validateTextFields();
        }
        catch (VWException e) {
            this.m_node.displayError(e);
            return false;
        }
        return true;
    }
}

